# 程序员高效工作技巧

> 提升工作效率，轻松应对职场挑战



你好，我是程序员鱼皮。

提到程序员，很多还没毕业的小伙伴可能觉得程序员的工作就是整天写代码，但进了公司后，你才会发现写代码只是工作中最最最基础的环节。

想要高效地完成工作、尽快在工作中取得成长和晋升，还有很多需要注重的事情和方法。

这篇文章就给大家分享一下我在工作中积累的程序员工作技巧吧，大家读起来应该是比较轻松的~

💡 注意，以下方法未必适用于所有人，仅提供建议



## 一、工作方法


### 1、没有明确需求前，不要急着做

我刚进公司的时候，会有一种应届生心态：同事都是我的前辈，他们给我提的需求我都要尽快完成。

而且那会儿自己初入职场，有一种莫名的自信，会觉得有些需求很简单，能做就做了。

结果有一次就翻车了，我以为有一个需求很简单，就跟我导师说我这两天就能完成。结果改完代码，跟产品经理交付的时候才发现我完全理解错了他的意思，然后又花了几周才把需求做完。

说到错误理解需求，我想到一个段子：

> 老婆给当程序员的老公打电话："下班顺路买一斤包子带回来，如果看到卖西瓜的，买一个。"
>
> 当晚，程序员老公手捧一个包子进了家门……
>
> 老婆怒道："你怎么就买了一个包子？" 
>
> 老公答曰："因为看到了卖西瓜的。"



所以大家一定要记住，明确需求始终是我们程序员工作的第一环！包括明确需求的背景、意义、具体的功能点等等。

如果产品经理没有给出需求单、给出足够的信息，那么一定要让他提供清晰的需求文档，确保你们的理解和目标是一致的，再去设计方案和开发。

千万记住，不要接受一句话需求、需求信息一定不能只通过口头描述！否则今后产品经理抵赖，你也没办法。

![需求文档](https://pic.yupi.icu/1/1696339052753-853d6116-984f-4f94-8bdf-9cf40c61109a.png)



### 2、上游没有确定前，不要急着开发

这点其实和上一点有点类似，对于我们程序员来说，可能有很多来自不同岗位、部门的上游，比如提需求的产品经理、核对功能点的测试、提供依赖接口的开发、提供资源权限的运维等。

如果我们实现需求必须依赖一些上游，我个人不建议直接上手开发（但是可以先做设计）。因为在工作中，总会有各种各样超出预期的变数和风险。

举个例子，前段时间我要基于其他部门提供的数据表 A 开发出数据表 B，最开始他们给了我数据表 A 的表结构，但是并不明确、并没有建好数据表并写入数据。如果是我刚工作的时候，可能就立刻基于这个表结构去写代码了。但后来，他们的数据表 A 的结构变了好几次、还换了好几次表名！他们表示很抱歉，但我却淡然一笑：没事，你们变吧，我还没开始做，等你们把表上线了再说~

如果是以前，我可能已经心态爆炸了吧哈哈。

![心态爆炸](https://pic.yupi.icu/1/1696339052793-e3154265-d287-48e8-851c-86c43a831b75.png)

所以这一点还是很有用的，也为我节省了不少时间。

但是，对于紧急需求，最好还是开会拉着所有上游同学一起核对，把方案先定下来，然后大家再各自分工开发、对齐。



### 3、学会预留空间

前面提到，刚进公司的时候，我还是比较自信的（现在想想有点自负了），总觉得自己能很快地完成需求，而且觉得需求做的越快越能得到老板的赏识。

结果就导致需求排期的时候给自己安排的太紧了，前一个需求的 Bug 还没修完，下一个需求又快到截止日期了。不仅让自己身心俱疲，也打了自己的脸，辜负了别人的期待吧。

而且自己长期负责一个项目后，我会发现很多时候你在做新需求时，用户会突然反馈一个历史功能的 Bug，你又不得不立刻抽身去修复。

所以之后做需求的时候我都会给自己多预留一些时间，防止一些自己前期没有考虑到的问题出现，毕竟大家也知道，有时候一个 Bug 可能就要排查一天。。。

![预留时间](https://pic.yupi.icu/1/1696339052824-38062959-00d7-4c9c-a00f-3583376a4737.png)

哪怕我很清楚自己 2 天能完成需求，可能也会多给自己一些时间。毕竟你如果能提前完成，对方会觉得超出预期了；如果你准时完成，对方会觉得这是正常的；而如果你因为一些 Bug 导致没有按时完成，对方会觉得 "你不太行"。

这也算是一种心理博弈？



### 4、学会向上管理

在职场中，很多人明明技术能力很强，但为什么得不到老板的器重、或者迟迟没有得到晋升呢？

很大的一个原因就是缺少 **向上管理** 的意识。

向上管理是指在日常工作中与上级进行良性互动，积极主动地提出建议、解决问题、持续反馈、维护和上级的关系的能力。

有很多做好向上管理的方法，比如：

1）主动提供解决方案：当你遇到问题或困难时，不要仅仅将问题呈现给你的上级，而是尝试提出可行的解决方案。

2）持续沟通和反馈：建议在合理范围内，定期与上级进行坦诚地交流沟通，包括表述自己的想法和规划、反馈自己的工作情况和成果、和上级对齐组内的目标。

千万不要说你自己做了很多 "自以为很牛 X" 的工作，结果上级根本不知道、或者对于组内和他个人的目标毫无价值，那就很可惜了。

3）展现自我领导力：你不仅要在领导下工作，还要能够在没有明确领导的情况下做出正确的决策，也就是我们公司企业文化中的 "主人翁意识"。

4）接受反馈：如果你的上级提供了建议或批评，不要将其视为攻击，而是视为一个机会来改进自己。积极地回应反馈，表现出你愿意学习和成长的态度。



## 二、时间管理大法

1、制定清晰的任务清单

按照优先级整理自己的每日任务，一条条打 ✅ 完成，增加动力。

2、时间切片

将每天的时间分段，每段只专注完成一个小任务，减少连续高强度学习的压力。

3、分解复杂任务

把大任务分成小步骤，逐步攻克，尤其适合写论文、搞大项目和方案。当你觉得做一件事情很难时，就必须这么做。

4、学会适时放弃

拒绝一些不重要的任务，不要让一些小事干扰了你的节奏。

5、减少无效信息

限制刷手机的时间，工作时设置为免打扰。你是要干大事的人，怎么能沉迷于某音某手某书？

6、劳逸结合

休息是非常有必要的，学习工作一段时间后，去接杯水吧~

7、利用碎片时间

如果你真的很忙，不妨利用通勤等零碎时间完成小任务，比如回复消息、读文章背单词等等。

8、批量处理任务

把相似任务集中处理，节省切换时间。我也是这么建议团队的运营和销售同学的，如果每分钟都盯着消息看，就没有连续的时间做其他工作了。

9、倒计时法

给任务强行添加一个时间限制，鼓励自己快速完成。看过我教程的同学应该知道，经典 "20 分钟" 嘛，就是这个作用。



## 三、任务管理


### 1、不要依赖人脑记事

一定不要依赖 "人脑" 记事，像我有的时候走出自己的办公室，就会有好几个同事找我确认各种事项，可能等我出去接杯水回来就忘掉了一些。所以必然要有自己的事项记录工具。

大家都是用什么工具来记录工作事项的呢？

像我以前用过滴答清单，类似一个高级的备忘录，但后来就不用了，因为要额外打开软件，还是不够方便。



### 2、利用微信记录

现在，我最常用的临时记录工具，正是我们每天都会使用的软件 —— 微信。

我的工作微信中，文件传输助手始终是置顶的，我不在电脑前面的时候，只要想到或者收到一些工作事项，都会发给文件传输助手，然后标为未读，以后每次打开微信，都会有一个醒目的红点提醒了。

![文件传输助手](https://pic.yupi.icu/1/image-20240804144855349.png)

如果收到暂时无法处理的工作消息，我在阅读之后也会标为未读并且置顶聊天，提醒自己之后要处理。大家在工作中遇到已读不回的情况，其实是很正常的，有可能对方只是暂时不方便回复、或者没想好怎么回。



### 3、使用工作记录表

除了利用微信来记录临时工作消息外，肯定还需要一个更系统的工具来记录每日的工作事项。

我使用的工具是腾讯文档的在线 Excel 表格，一方面是直接就能在企微或浏览器里打开，另外一方面现在的在线 Excel 表格功能已经非常灵活，可以很方便地根据自己的需要记录信息、对信息进行分组等等。

比如我是按照每天的日期进行分组，记录了工作事项、备注、相关文档、工作进度等信息。如果某一天的工作做不完，我只需要改下日期到第二天；如果担心有项工作之后会忘掉，只需要提前把它记录到表格里就好。

每天过一遍工作记录表，就不容易遗漏掉工作，更容易安排好自己的时间，还可以通过查看记录对自己的过去进行一个复盘。

以下是我的工作记录表示例：

![工作记录表](https://pic.yupi.icu/1/image-20240804143618230.png)

像我带了团队之后，还有一个习惯，在每个周末提前做好下周整体的个人和团队计划，便于提前做好准备、更好地把控进度，让工作井然有序。



### 4、睡前过一遍红点

由于我平时工作消息非常多，不可能做到什么消息都很快回复，那样我根本无法静下心来做好一件事。

但是我每天睡觉前都会过一遍微信 / 企业微信中的 "红点"，确认下有没有漏掉的消息，这可能也是导致我睡眠时间不固定的一个主要原因。

![过红点](https://pic.yupi.icu/1/image-20240804144027111.png)



## 四、日常记录总结

经常有朋友跟我吐槽说自己进公司很久了，但感觉一直都没什么成长，每次汇报的时候也不知道说什么。

如果你也有这种想法，那么大概率你是没有日常总结的习惯的。

我自己以前存在的一个问题是：看网课做笔记时，有时候会偷懒，我会想着多看几集一起记录。结果现实往往是，随着我看的集数越来越多、未记录笔记的集数越堆越多，我会觉得记录笔记的压力越来越大，到最后索性不记了。

有没有同学也是这样？

工作总结也是一样，最好大家每完成一天的工作、每次做完一个需求、每产出一个阶段性成果，都立刻把他记录下来，养成日常记录的习惯，并且定期整理总结、复盘。才不会说堆到最后都懒得去记了，等到写总结的时候也忘了自己今年做过什么。

这个习惯我已经坚持了 3 年，不得不说，对我的帮助很大。也能时刻让我反思自己的工作节奏、状态，激励自己去尝试和突破。



## 五、效率提升法则

1、先完成确定的工作

没想好怎么办时，先做清楚的任务。比如我写文章没灵感时，就不会硬想，而是先去做别的，把控整体的工作进度。

2、完成比完美更重要

不要过分追求完美，完成比完美更重要。敏捷开发、持续迭代就是这个道理。（当然，如果不完美的完成对你来说毫无意义，那就按照你的节奏去做就好了）

3、有现成的代码，就不要自己写

学习除外。

4、做项目前，要先想清楚怎么做

做好充分的预研和设计。这样不仅便于后续的程序扩展，也能避免无意义的返工。

5、将大的目标进行拆解

做好计划，标记出关键节点，不要因为觉得目标遥不可及而拖延，也不要盲目乐观而松懈。

6、养成好的作息习惯

找到自己适合工作的黄金时间。（可惜我的黄金时间在凌晨。。。）

7、记性不好，就多记录

哪怕实在记不住，也可以借助文档、收藏夹软件来当自己的第二大脑。

8、积累属于自己的工具库

配合搜索软件实现随用随取。

9、多和团队成员交流

也可以关注一些 UP 主，拓宽知识渠道，从而了解更多的工具和方法。有些东西你只要听说过，等到要用时说不定就能节省几个小时的查找时间。

10、找到让自己进入心流的方法

比如戴上耳机、嚼口香糖、喝咖啡、深呼吸等。

11、经历过的事情，再做一次，通常会更快

因此，要多做项目，持续积累经验，熟能生巧。



## 写在最后

也许有朋友会觉得：什么都做计划，把自己的人生困在了 Excel 工作表格中，真累啊！

我想说：对啊，确实很累。但当我养成了记录和做计划的习惯后，我做事不再迷茫，而是更有目标了，知道接下来该做什么，也不担心自己会耽误事情。而且看着自己的工作记录表充满 100% 的进度，成就感爆棚！

就这么多，虽说比较抽象，但细细品味，相信你会有一种豁然开朗、醍醐灌顶的感觉。

综上，希望这些技巧对大家有帮助，早日升职加薪~




## 推荐资源

1）鱼皮 AI 导航网站：[AI 资源大全、最新 AI 资讯、免费 AI 教程](https://ai.codefather.cn)

2）编程导航学习圈：[学习路线、编程教程、实战项目、求职宝典、交流答疑](https://www.codefather.cn)

3）程序员面试八股文：[实习/校招/社招高频考点、企业真题解析](https://www.mianshiya.com)

4）程序员写简历神器：[专业模板、丰富例句、直通面试](https://www.laoyujianli.com)

5）1 对 1 模拟面试：[实习/校招/社招面试拿 Offer 必备](https://ai.mianshiya.com)
